﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
using Inet.Viewer.Resources;

namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// Responsible for a panel for a boolean prompt
    /// </summary>
    public partial class SingleBooleanPromptField : PromptControl
    {
        /// <summary>
        /// Simple constructor with dependency of the prompt field this panel is for
        /// </summary>
        /// <param name="promptData">Prompt field this panel is for</param>
        public SingleBooleanPromptField(PromptData promptData)
        {
            this.PromptData = promptData;
            InitializeComponent();
            this.cmbValueBox.TextChanged += new System.EventHandler(this.HandleChanged);
            this.cmbValueBox.DropDownStyle = ComboBoxStyle.DropDownList;
            List<SinglePromptValue> defaultBools = new List<SinglePromptValue>();
            if (this.PromptData.DefaultValues != null && this.PromptData.DefaultValues.Count > 0)
            {
                defaultBools.AddRange(PromptData.DefaultValues.Cast<SinglePromptValue>());
            }

            if (promptData.Changeable && !defaultBools.Any(e => e.Value is Boolean && (Boolean)e.Value))
            {
                SinglePromptValue yes = new SinglePromptValue(true, null, PromptData.Boolean);
                defaultBools.Add(yes);
            }
            if (promptData.Changeable && !defaultBools.Any(e => e.Value is Boolean && !(Boolean)e.Value))
            {
                SinglePromptValue no = new SinglePromptValue(false, null, PromptData.Boolean);
                defaultBools.Add(no);
            }
            this.cmbValueBox.DataSource = defaultBools;
            this.cmbValueBox.DisplayMember = "DisplayString";
            this.cmbValueBox.ValueMember = "Value";
            PromptValue alreadySelectedValue = promptData.Values;
            if (alreadySelectedValue != null)
            {
                foreach (PromptValue v in this.cmbValueBox.Items)
                {
                    if (alreadySelectedValue == v || alreadySelectedValue.Equals(v))
                    {
                        this.cmbValueBox.SelectedItem = v;
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        internal override PromptValue Value
        {
            get
            {
                return this.cmbValueBox.SelectedItem as PromptValue;
            }
        }

        /// <inheritdoc/>
        internal override bool ValidatePrompt()
        {
            return true;
        }
    }
}
